/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.base;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_310;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.dataticket.DataTicket;

public interface GeoRenderState {
    default public <D> void addGeckolibData(DataTicket<D> dataTicket, D data) {
        this.getDataMap().put(dataTicket, data);
    }

    default public boolean hasGeckolibData(DataTicket<?> dataTicket) {
        return this.getDataMap().containsKey(dataTicket);
    }

    default public <D> @Nullable D getGeckolibData(DataTicket<D> dataTicket) {
        Object data = this.getDataMap().get(dataTicket);
        try {
            return (D)data;
        }
        catch (ClassCastException ex) {
            GeckoLibConstants.LOGGER.error("Attempted to retrieve incorrectly typed data from GeoRenderState. Possibly a mod or DataTicket conflict? Expected: {}, found data type {}", dataTicket, (Object)data.getClass().getName(), (Object)ex);
            throw ex;
        }
    }

    @Contract(value="_,null->null;_,!null->!null")
    default public <D> @Nullable D getOrDefaultGeckolibData(DataTicket<D> dataTicket, @Nullable D defaultValue) {
        D data = this.getGeckolibData(dataTicket);
        return data != null ? data : defaultValue;
    }

    default public <D> @Nullable D getOrDefaultGeckolibData(DataTicket<D> dataTicket, Supplier<@Nullable D> defaultValue) {
        D data = this.getGeckolibData(dataTicket);
        return data != null ? data : defaultValue.get();
    }

    default public int getPackedLight() {
        return this.getOrDefaultGeckolibData(DataTickets.PACKED_LIGHT, 0xF000F0);
    }

    default public float getPartialTick() {
        return this.getOrDefaultGeckolibData(DataTickets.PARTIAL_TICK, Float.valueOf(class_310.method_1551().method_61966().method_60637(false))).floatValue();
    }

    default public double getAnimatableAge() {
        return this.getOrDefaultGeckolibData(DataTickets.TICK, 0.0);
    }

    @ApiStatus.Internal
    public Map<DataTicket<?>, Object> getDataMap();

    @ApiStatus.Internal
    public record Impl(Map<DataTicket<?>, Object> data) implements GeoRenderState
    {
        public Impl() {
            this((Map<DataTicket<?>, Object>)new Reference2ObjectOpenHashMap());
        }

        @Override
        @ApiStatus.Internal
        public Map<DataTicket<?>, Object> getDataMap() {
            return this.data;
        }
    }
}

